/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sensedia.interceptor.externaljar.dto.MultiTenantEntity;
import com.sensedia.interceptor.externaljar.dto.Plan;
import com.sensedia.interceptor.externaljar.dto.TokenInfo;
import com.sensedia.interceptor.externaljar.dto.TokenStatusEnum;
import com.sensedia.interceptor.externaljar.dto.TokenTypeEnum;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken
extends MultiTenantEntity<String>
implements TokenInfo {
    private static final long serialVersionUID = 1L;
    private Long id;
    public String _id;
    @NotBlank(message="{javax.validation.constraints.NotBlank.AccessToken.owner.message}")
    @Size(max=200)
    public @NotBlank(message="{javax.validation.constraints.NotBlank.AccessToken.owner.message}") @Size(max=200) String owner;
    @Min(value=0L, message="{javax.validation.constraints.Min.AccessToken.expiresIn.message}")
    public @Min(value=0L, message="{javax.validation.constraints.Min.AccessToken.expiresIn.message}") Long expiresIn;
    public String scope;
    public Long appId;
    @NotNull(message="{javax.validation.constraints.NotNull.AccessToken.appCode.message}")
    @Size(max=255)
    @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AppToken.code.message}")
    public @NotNull(message="{javax.validation.constraints.NotNull.AccessToken.appCode.message}") @Size(max=255) @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AppToken.code.message}") String appCode;
    @Size(max=255)
    @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AppToken.secret.message}")
    public @Size(max=255) @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AppToken.secret.message}") String appSecret;
    public Date expiredDate;
    @Size(max=255)
    public @Size(max=255) String appName;
    @Email
    @Pattern(regexp="(^$|[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)", message="_nls.email.invalid.message")
    public @Email @Pattern(regexp="(^$|[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)", message="_nls.email.invalid.message") String appDeveloper;
    public Date ttl;
    public Date expirationDate;
    @Size(max=255)
    @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AccessToken.refreshToken.message}")
    public @Size(max=255) @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AccessToken.refreshToken.message}") String refreshToken;
    @NotNull(message="{javax.validation.constraints.NotNull.AccessToken.status.message}")
    public @NotNull(message="{javax.validation.constraints.NotNull.AccessToken.status.message}") TokenStatusEnum status;
    @Size(max=3072)
    @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AccessToken.code.message}")
    public @Size(max=3072) @Pattern(regexp="[=A-Za-z0-9_.-]+", message="{javax.validation.constraints.Pattern.AccessToken.code.message}") String code;
    public Long creationDate;
    public Map<String, Object> extraInfo = new HashMap<String, Object>();
    public List<Plan> plans;
    public boolean readyToDelete;
    private boolean internal;

    private AccessToken(Builder builder) {
        this.set_id(builder._id);
        this.setOwner(builder.owner);
        this.setExpiresIn(builder.expiresIn);
        this.setScope(builder.scope);
        this.setAppId(builder.appId);
        this.setAppCode(builder.appCode);
        this.setAppSecret(builder.appSecret);
        this.setAppName(builder.appName);
        this.setAppDeveloper(builder.appDeveloper);
        this.setExpirationDate(builder.expirationDate);
        this.setRefreshToken(builder.refreshToken);
        this.setStatus(builder.status);
        this.setCode(builder.code);
        this.setCreationDate(builder.creationDate);
        this.setExtraInfo(builder.extraInfo);
        this.setPlans(builder.plans);
        this.setInternal(builder.internal);
    }

    public AccessToken() {
    }

    public AccessToken(String code, Long appId, String appCode, String appSecret) {
        this(code, appId, appCode, appSecret, null);
    }

    public AccessToken(String code, Long appId, String appCode, String appSecret, TokenStatusEnum status) {
        this.appId = appId;
        this.appCode = appCode;
        this.appSecret = appSecret;
        this.code = code;
        this.status = status;
    }

    public AccessToken(String _id, String owner, Long expiresIn, String scope, Long appId, String appCode, String appSecret, String appName, String appDeveloper, Date expirationDate, String refreshToken, TokenStatusEnum status, String code, Long creationDate, Map<String, Object> extraInfo, List<Plan> plans, boolean internal) {
        this(code, appId, appCode, appSecret, status);
        this._id = _id;
        this.owner = owner;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.appName = appName;
        this.appDeveloper = appDeveloper;
        this.expirationDate = expirationDate;
        this.refreshToken = refreshToken;
        this.creationDate = creationDate;
        this.extraInfo = extraInfo;
        this.plans = plans;
        this.internal = internal;
    }

    public String get_id() {
        return this._id;
    }

    public void set_id(String _id) {
        this._id = _id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Date getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    public Date getTtl() {
        return this.ttl;
    }

    public void setTtl(Date ttl) {
        this.ttl = ttl;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonIgnore
    public boolean isValidRefreshToken() {
        return Objects.nonNull(this.refreshToken) && !this.refreshToken.isEmpty() && !this.status.equals(TokenStatusEnum.REVOKED);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public TokenStatusEnum getStatus() {
        if (this.isExpired()) {
            return TokenStatusEnum.EXPIRED;
        }
        return this.status;
    }

    public void setStatus(TokenStatusEnum status) {
        this.status = status;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Map<String, Object> getExtraInfo() {
        return this.extraInfo;
    }

    public TokenInfo setExtraInfo(Map<String, Object> extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    @Override
    public List<Plan> getPlans() {
        return this.plans == null ? Collections.emptyList() : this.plans;
    }

    public void setPlans(List<Plan> plans) {
        this.plans = plans;
    }

    @Override
    @JsonIgnore
    public TokenTypeEnum getTokenTypeEnum() {
        return TokenTypeEnum.ACCESS_TOKEN;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppDeveloper() {
        return this.appDeveloper;
    }

    public void setAppDeveloper(String appDeveloper) {
        this.appDeveloper = appDeveloper;
    }

    public void setReadyToDelete(boolean readyToDelete) {
        this.readyToDelete = readyToDelete;
    }

    public void setPlanIds(List<Long> ids) {
        this.plans = new ArrayList<Plan>();
        if (Objects.nonNull(ids)) {
            ids.stream().forEach(item -> this.plans.add(new Plan((Long)item, null)));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appCode == null ? 0 : this.appCode.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        if (this.appCode == null ? other.appCode != null : !this.appCode.equals(other.appCode)) {
            return false;
        }
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    @Override
    @JsonIgnore
    public String getKey() {
        return this.getCode();
    }

    public String toString() {
        return "TokenInfo [type=" + this.getClass().getSimpleName() + ", code=" + this.code + ", status=" + this.status + "]";
    }

    @JsonIgnore
    private boolean isExpired() {
        if (TokenStatusEnum.ACTIVE.equals(this.status) && this.creationDate != null && this.expiresIn != null) {
            LocalDateTime creationDatePlusExpiration = Instant.ofEpochMilli(this.creationDate).atZone(ZoneId.systemDefault()).toLocalDateTime().plusSeconds(this.expiresIn);
            return creationDatePlusExpiration.isBefore(LocalDateTime.now());
        }
        return false;
    }

    public static class Builder {
        protected String _id;
        protected String owner;
        protected Long expiresIn;
        protected String scope;
        protected Long appId;
        protected String appCode;
        protected String appSecret;
        protected String appName;
        protected String appDeveloper;
        protected Date expirationDate;
        protected String refreshToken;
        protected TokenStatusEnum status;
        protected String code;
        protected Long creationDate;
        protected Map<String, Object> extraInfo = new HashMap<String, Object>();
        protected List<Plan> plans;
        protected boolean internal;

        public Builder _id(String _id) {
            this._id = _id;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder appId(Long appId) {
            this.appId = appId;
            return this;
        }

        public Builder appCode(String appCode) {
            this.appCode = appCode;
            return this;
        }

        public Builder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder appDeveloper(String appDeveloper) {
            this.appDeveloper = appDeveloper;
            return this;
        }

        public Builder expirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder status(TokenStatusEnum status) {
            this.status = status;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder creationDate(Long creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder extraInfo(Map<String, Object> extraInfo) {
            this.extraInfo = extraInfo;
            return this;
        }

        public Builder plans(List<Plan> plans) {
            this.plans = plans;
            return this;
        }

        public Builder internal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public AccessToken build() {
            return new AccessToken(this);
        }
    }
}

