/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.exception;

import com.sensedia.interceptor.externaljar.exception.FlowError;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import java.util.Objects;

public class ApiException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Integer httpErrorCode;
    private FlowError flowError;
    private MultiStringMap headers;

    private ApiException(FlowError flowError, Integer httpErrorCode, String message) {
        super(message);
        this.httpErrorCode = httpErrorCode;
        this.flowError = flowError;
    }

    public ApiException(Integer httpErrorCode, String message, Object ... params) {
        this(new FlowError.FlowErrorBuilder().httpErrorCode(httpErrorCode).message(ApiException.getMessage(message, params)), httpErrorCode, ApiException.getMessage(message, params));
    }

    public ApiException(FlowError flowError, Integer httpErrorCode, String message, Object ... params) {
        this(flowError, httpErrorCode, ApiException.getMessage(message, params));
    }

    public ApiException(FlowError flowError, MultiStringMap headers, Integer httpErrorCode, String message, Object ... params) {
        this(flowError, httpErrorCode, ApiException.getMessage(message, params));
        this.headers = headers;
    }

    public Integer getCode() {
        return this.httpErrorCode;
    }

    public FlowError getFlowError() {
        return this.flowError;
    }

    public MultiStringMap getHeaders() {
        if (Objects.isNull(this.headers)) {
            this.headers = new MultiStringMap();
        }
        return this.headers;
    }

    protected static String getMessage(String message, Object ... params) {
        if (Objects.nonNull(params) && params.length > 0) {
            return String.format(message, params);
        }
        return message;
    }
}

