/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;

public class RESTRequest {
    private Map<String, String> headers = new HashMap<String, String>();
    private String method;
    private String uri;
    private Object body;

    public RESTRequest() {
    }

    public RESTRequest(String method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public RESTRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public RESTRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public RESTRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public RESTRequest setTextBody(String body) {
        this.body = body;
        this.setHeader("Content-Type", "text/plain");
        return this;
    }

    public RESTRequest setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public RESTRequest setJsonBody(Object o) {
        try {
            this.body = new ObjectMapper().writeValueAsString(o);
            this.setHeader("Content-Type", "application/json");
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RESTRequest setFilePartBody(String partName, File file) {
        this.body = new FormBodyPart(partName, (ContentBody)new FileBody(file));
        return this;
    }

    public RESTRequest setFilePartBody(String partName, String fileName, byte[] fileContents) {
        this.body = new FormBodyPart(partName, (ContentBody)new ByteArrayBody(fileContents, fileName));
        return this;
    }
}

