/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.util;

import com.sensedia.interceptor.externaljar.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public class GZIP {
    private static final int BUFFER_SIZE = 32;

    public byte[] compress(String string) {
        byte[] blockcopy = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(string.length()).array();
        String encoded = Base64.encodeString(string);
        ByteArrayOutputStream os = new ByteArrayOutputStream(encoded.length());
        byte[] compressed = null;
        try {
            GZIPOutputStream gos = new GZIPOutputStream(os);
            gos.write(encoded.getBytes());
            gos.close();
            os.close();
            compressed = new byte[4 + os.toByteArray().length];
            System.arraycopy(blockcopy, 0, compressed, 0, 4);
            System.arraycopy(os.toByteArray(), 0, compressed, 4, os.toByteArray().length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return compressed;
    }

    public String decompress(byte[] compressed) {
        ByteArrayInputStream is = new ByteArrayInputStream(compressed, 4, compressed.length - 4);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int bytesRead;
            GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                stringBuilder.append(new String(data, 0, bytesRead));
            }
            gis.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Base64.isBase64String(stringBuilder.toString())) {
            return Base64.decodeString(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    public static byte[] compressData(byte[] data) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] decompressData(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

